@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property refreshConfiguration The refresh configuration for the data set. See refresh_configuration.
 */
public data class DataSetRefreshPropertiesArgs(
    public val refreshConfiguration: Output<DataSetRefreshPropertiesRefreshConfigurationArgs>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesArgs =
        com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesArgs.builder()
            .refreshConfiguration(
                refreshConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSetRefreshPropertiesArgs].
 */
@PulumiTagMarker
public class DataSetRefreshPropertiesArgsBuilder internal constructor() {
    private var refreshConfiguration: Output<DataSetRefreshPropertiesRefreshConfigurationArgs>? = null

    /**
     * @param value The refresh configuration for the data set. See refresh_configuration.
     */
    @JvmName("xckcxhhsrjfgxtsw")
    public suspend fun refreshConfiguration(`value`: Output<DataSetRefreshPropertiesRefreshConfigurationArgs>) {
        this.refreshConfiguration = value
    }

    /**
     * @param value The refresh configuration for the data set. See refresh_configuration.
     */
    @JvmName("isaludvadyprgmgv")
    public suspend fun refreshConfiguration(`value`: DataSetRefreshPropertiesRefreshConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshConfiguration = mapped
    }

    /**
     * @param argument The refresh configuration for the data set. See refresh_configuration.
     */
    @JvmName("sktcfhvodlqrfwtv")
    public suspend fun refreshConfiguration(argument: suspend DataSetRefreshPropertiesRefreshConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetRefreshPropertiesRefreshConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.refreshConfiguration = mapped
    }

    internal fun build(): DataSetRefreshPropertiesArgs = DataSetRefreshPropertiesArgs(
        refreshConfiguration = refreshConfiguration ?: throw
            PulumiNullFieldException("refreshConfiguration"),
    )
}
