@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property lookbackWindow The lookback window setup for an incremental refresh configuration. See lookback_window.
 */
public data class DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs(
    public val lookbackWindow: Output<DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs =
        com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs.builder()
            .lookbackWindow(
                lookbackWindow.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs].
 */
@PulumiTagMarker
public class DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgsBuilder internal constructor() {
    private var lookbackWindow:
        Output<DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs>? =
        null

    /**
     * @param value The lookback window setup for an incremental refresh configuration. See lookback_window.
     */
    @JvmName("opqctcdamaccoggu")
    public suspend fun lookbackWindow(`value`: Output<DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs>) {
        this.lookbackWindow = value
    }

    /**
     * @param value The lookback window setup for an incremental refresh configuration. See lookback_window.
     */
    @JvmName("mpkfwbtkphknjooa")
    public suspend fun lookbackWindow(`value`: DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lookbackWindow = mapped
    }

    /**
     * @param argument The lookback window setup for an incremental refresh configuration. See lookback_window.
     */
    @JvmName("xyuijgpwdlktxjjs")
    public suspend fun lookbackWindow(argument: suspend DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.lookbackWindow = mapped
    }

    internal fun build(): DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs =
        DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs(
            lookbackWindow = lookbackWindow ?: throw PulumiNullFieldException("lookbackWindow"),
        )
}
