@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property columnName The name of the lookback window column.
 * @property size The lookback window column size.
 * @property sizeUnit The size unit that is used for the lookback window column. Valid values for this structure are `HOUR`, `DAY`, and `WEEK`.
 */
public data class DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs(
    public val columnName: Output<String>,
    public val size: Output<Int>,
    public val sizeUnit: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs =
        com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs.builder()
            .columnName(columnName.applyValue({ args0 -> args0 }))
            .size(size.applyValue({ args0 -> args0 }))
            .sizeUnit(sizeUnit.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs].
 */
@PulumiTagMarker
public class DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgsBuilder
internal constructor() {
    private var columnName: Output<String>? = null

    private var size: Output<Int>? = null

    private var sizeUnit: Output<String>? = null

    /**
     * @param value The name of the lookback window column.
     */
    @JvmName("yupudbcefwxbtrqm")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value The lookback window column size.
     */
    @JvmName("sxnfmirknibeucny")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The size unit that is used for the lookback window column. Valid values for this structure are `HOUR`, `DAY`, and `WEEK`.
     */
    @JvmName("yfrxfglvtoxalrab")
    public suspend fun sizeUnit(`value`: Output<String>) {
        this.sizeUnit = value
    }

    /**
     * @param value The name of the lookback window column.
     */
    @JvmName("xjvwjsmuqkempkel")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value The lookback window column size.
     */
    @JvmName("erksigtrmuwgavcl")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The size unit that is used for the lookback window column. Valid values for this structure are `HOUR`, `DAY`, and `WEEK`.
     */
    @JvmName("eymnliyucqbcnngu")
    public suspend fun sizeUnit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizeUnit = mapped
    }

    internal fun build(): DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs =
        DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshLookbackWindowArgs(
            columnName = columnName ?: throw PulumiNullFieldException("columnName"),
            size = size ?: throw PulumiNullFieldException("size"),
            sizeUnit = sizeUnit ?: throw PulumiNullFieldException("sizeUnit"),
        )
}
