@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionDataSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN of the dataset that contains permissions for RLS.
 * @property formatVersion User or group rules associated with the dataset that contains permissions for RLS.
 * @property namespace Namespace associated with the dataset that contains permissions for RLS.
 * @property permissionPolicy Type of permissions to use when interpreting the permissions for RLS. Valid values are `GRANT_ACCESS` and `DENY_ACCESS`.
 * @property status Status of the row-level security permission dataset. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
 */
public data class DataSetRowLevelPermissionDataSetArgs(
    public val arn: Output<String>,
    public val formatVersion: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val permissionPolicy: Output<String>,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionDataSetArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionDataSetArgs =
        com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionDataSetArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .formatVersion(formatVersion?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .permissionPolicy(permissionPolicy.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetRowLevelPermissionDataSetArgs].
 */
@PulumiTagMarker
public class DataSetRowLevelPermissionDataSetArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var formatVersion: Output<String>? = null

    private var namespace: Output<String>? = null

    private var permissionPolicy: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value ARN of the dataset that contains permissions for RLS.
     */
    @JvmName("skjlumtrsxuafxco")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value User or group rules associated with the dataset that contains permissions for RLS.
     */
    @JvmName("muemgwdygxoiwcuw")
    public suspend fun formatVersion(`value`: Output<String>) {
        this.formatVersion = value
    }

    /**
     * @param value Namespace associated with the dataset that contains permissions for RLS.
     */
    @JvmName("qeodlvssbrmrlcrt")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Type of permissions to use when interpreting the permissions for RLS. Valid values are `GRANT_ACCESS` and `DENY_ACCESS`.
     */
    @JvmName("mquqlxmabkwrcsbn")
    public suspend fun permissionPolicy(`value`: Output<String>) {
        this.permissionPolicy = value
    }

    /**
     * @param value Status of the row-level security permission dataset. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
     */
    @JvmName("wddgwceyhosklbwy")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value ARN of the dataset that contains permissions for RLS.
     */
    @JvmName("ichhhmbdoecfhrbr")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value User or group rules associated with the dataset that contains permissions for RLS.
     */
    @JvmName("wypcvskoknrqegmf")
    public suspend fun formatVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.formatVersion = mapped
    }

    /**
     * @param value Namespace associated with the dataset that contains permissions for RLS.
     */
    @JvmName("wpajmpwvbhcgxkdm")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Type of permissions to use when interpreting the permissions for RLS. Valid values are `GRANT_ACCESS` and `DENY_ACCESS`.
     */
    @JvmName("jneicwdbejioxnne")
    public suspend fun permissionPolicy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissionPolicy = mapped
    }

    /**
     * @param value Status of the row-level security permission dataset. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
     */
    @JvmName("uuiirvpdvbollamv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DataSetRowLevelPermissionDataSetArgs = DataSetRowLevelPermissionDataSetArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        formatVersion = formatVersion,
        namespace = namespace,
        permissionPolicy = permissionPolicy ?: throw PulumiNullFieldException("permissionPolicy"),
        status = status,
    )
}
