@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property status The status of row-level security tags. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
 * @property tagRules A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. See tag_rules.
 */
public data class DataSetRowLevelPermissionTagConfigurationArgs(
    public val status: Output<String>? = null,
    public val tagRules: Output<List<DataSetRowLevelPermissionTagConfigurationTagRuleArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationArgs.builder()
            .status(status?.applyValue({ args0 -> args0 }))
            .tagRules(
                tagRules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSetRowLevelPermissionTagConfigurationArgs].
 */
@PulumiTagMarker
public class DataSetRowLevelPermissionTagConfigurationArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    private var tagRules: Output<List<DataSetRowLevelPermissionTagConfigurationTagRuleArgs>>? = null

    /**
     * @param value The status of row-level security tags. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
     */
    @JvmName("ygcgjhwtrewpgels")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. See tag_rules.
     */
    @JvmName("jhdfypwyyyklclbo")
    public suspend fun tagRules(`value`: Output<List<DataSetRowLevelPermissionTagConfigurationTagRuleArgs>>) {
        this.tagRules = value
    }

    @JvmName("ggdiaoodjyypvcfk")
    public suspend fun tagRules(vararg values: Output<DataSetRowLevelPermissionTagConfigurationTagRuleArgs>) {
        this.tagRules = Output.all(values.asList())
    }

    /**
     * @param values A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. See tag_rules.
     */
    @JvmName("qeispepgbkdrwmbx")
    public suspend fun tagRules(values: List<Output<DataSetRowLevelPermissionTagConfigurationTagRuleArgs>>) {
        this.tagRules = Output.all(values)
    }

    /**
     * @param value The status of row-level security tags. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
     */
    @JvmName("owwmosxiywgqfhll")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. See tag_rules.
     */
    @JvmName("hsiuokkxqlgouelg")
    public suspend fun tagRules(`value`: List<DataSetRowLevelPermissionTagConfigurationTagRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagRules = mapped
    }

    /**
     * @param argument A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. See tag_rules.
     */
    @JvmName("eogiwjkbkqgnuuvd")
    public suspend fun tagRules(argument: List<suspend DataSetRowLevelPermissionTagConfigurationTagRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetRowLevelPermissionTagConfigurationTagRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tagRules = mapped
    }

    /**
     * @param argument A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. See tag_rules.
     */
    @JvmName("uqnquujauyfuvvhr")
    public suspend fun tagRules(vararg argument: suspend DataSetRowLevelPermissionTagConfigurationTagRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataSetRowLevelPermissionTagConfigurationTagRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tagRules = mapped
    }

    /**
     * @param argument A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. See tag_rules.
     */
    @JvmName("hxbarjqdxhjdmnyj")
    public suspend fun tagRules(argument: suspend DataSetRowLevelPermissionTagConfigurationTagRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DataSetRowLevelPermissionTagConfigurationTagRuleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.tagRules = mapped
    }

    /**
     * @param values A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. See tag_rules.
     */
    @JvmName("krsqffdwlrhwplhc")
    public suspend fun tagRules(vararg values: DataSetRowLevelPermissionTagConfigurationTagRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagRules = mapped
    }

    internal fun build(): DataSetRowLevelPermissionTagConfigurationArgs =
        DataSetRowLevelPermissionTagConfigurationArgs(
            status = status,
            tagRules = tagRules ?: throw PulumiNullFieldException("tagRules"),
        )
}
