@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationTagRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property columnName Column name that a tag key is assigned to.
 * @property matchAllValue A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one.
 * @property tagKey Unique key for a tag.
 * @property tagMultiValueDelimiter A string that you want to use to delimit the values when you pass the values at run time.
 */
public data class DataSetRowLevelPermissionTagConfigurationTagRuleArgs(
    public val columnName: Output<String>,
    public val matchAllValue: Output<String>? = null,
    public val tagKey: Output<String>,
    public val tagMultiValueDelimiter: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationTagRuleArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationTagRuleArgs =
        com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationTagRuleArgs.builder()
            .columnName(columnName.applyValue({ args0 -> args0 }))
            .matchAllValue(matchAllValue?.applyValue({ args0 -> args0 }))
            .tagKey(tagKey.applyValue({ args0 -> args0 }))
            .tagMultiValueDelimiter(tagMultiValueDelimiter?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetRowLevelPermissionTagConfigurationTagRuleArgs].
 */
@PulumiTagMarker
public class DataSetRowLevelPermissionTagConfigurationTagRuleArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var matchAllValue: Output<String>? = null

    private var tagKey: Output<String>? = null

    private var tagMultiValueDelimiter: Output<String>? = null

    /**
     * @param value Column name that a tag key is assigned to.
     */
    @JvmName("xiwpjmbojjpbuypc")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one.
     */
    @JvmName("oskkvlfomncpghvk")
    public suspend fun matchAllValue(`value`: Output<String>) {
        this.matchAllValue = value
    }

    /**
     * @param value Unique key for a tag.
     */
    @JvmName("csxrthaligpivsmj")
    public suspend fun tagKey(`value`: Output<String>) {
        this.tagKey = value
    }

    /**
     * @param value A string that you want to use to delimit the values when you pass the values at run time.
     */
    @JvmName("gnmhiqnybvgtmjjs")
    public suspend fun tagMultiValueDelimiter(`value`: Output<String>) {
        this.tagMultiValueDelimiter = value
    }

    /**
     * @param value Column name that a tag key is assigned to.
     */
    @JvmName("kchyjvuiruigewuu")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one.
     */
    @JvmName("dpjhdbwmfnydyvcr")
    public suspend fun matchAllValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchAllValue = mapped
    }

    /**
     * @param value Unique key for a tag.
     */
    @JvmName("wyhaysmjevxaophu")
    public suspend fun tagKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagKey = mapped
    }

    /**
     * @param value A string that you want to use to delimit the values when you pass the values at run time.
     */
    @JvmName("bicxsxirkvwcrjgl")
    public suspend fun tagMultiValueDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagMultiValueDelimiter = mapped
    }

    internal fun build(): DataSetRowLevelPermissionTagConfigurationTagRuleArgs =
        DataSetRowLevelPermissionTagConfigurationTagRuleArgs(
            columnName = columnName ?: throw PulumiNullFieldException("columnName"),
            matchAllValue = matchAllValue,
            tagKey = tagKey ?: throw PulumiNullFieldException("tagKey"),
            tagMultiValueDelimiter = tagMultiValueDelimiter,
        )
}
