@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property copySourceArn The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use.
 * When the value is not null, the `credential_pair` from the data source in the ARN is used.
 * @property credentialPair Credential pair. See Credential Pair below for more details.
 */
public data class DataSourceCredentialsArgs(
    public val copySourceArn: Output<String>? = null,
    public val credentialPair: Output<DataSourceCredentialsCredentialPairArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceCredentialsArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceCredentialsArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceCredentialsArgs.builder()
            .copySourceArn(copySourceArn?.applyValue({ args0 -> args0 }))
            .credentialPair(
                credentialPair?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSourceCredentialsArgs].
 */
@PulumiTagMarker
public class DataSourceCredentialsArgsBuilder internal constructor() {
    private var copySourceArn: Output<String>? = null

    private var credentialPair: Output<DataSourceCredentialsCredentialPairArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use.
     * When the value is not null, the `credential_pair` from the data source in the ARN is used.
     */
    @JvmName("cosmkybtvlqaagic")
    public suspend fun copySourceArn(`value`: Output<String>) {
        this.copySourceArn = value
    }

    /**
     * @param value Credential pair. See Credential Pair below for more details.
     */
    @JvmName("kwrfjebvjcpffrig")
    public suspend fun credentialPair(`value`: Output<DataSourceCredentialsCredentialPairArgs>) {
        this.credentialPair = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use.
     * When the value is not null, the `credential_pair` from the data source in the ARN is used.
     */
    @JvmName("uslemqapanvosjrc")
    public suspend fun copySourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copySourceArn = mapped
    }

    /**
     * @param value Credential pair. See Credential Pair below for more details.
     */
    @JvmName("snxkgjfrkwqpodrq")
    public suspend fun credentialPair(`value`: DataSourceCredentialsCredentialPairArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialPair = mapped
    }

    /**
     * @param argument Credential pair. See Credential Pair below for more details.
     */
    @JvmName("hbrgxthjqhrxrspo")
    public suspend fun credentialPair(argument: suspend DataSourceCredentialsCredentialPairArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceCredentialsCredentialPairArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credentialPair = mapped
    }

    internal fun build(): DataSourceCredentialsArgs = DataSourceCredentialsArgs(
        copySourceArn = copySourceArn,
        credentialPair = credentialPair,
    )
}
