@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceCredentialsCredentialPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password Password, maximum length of 1024 characters.
 * @property username User name, maximum length of 64 characters.
 */
public data class DataSourceCredentialsCredentialPairArgs(
    public val password: Output<String>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceCredentialsCredentialPairArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceCredentialsCredentialPairArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceCredentialsCredentialPairArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceCredentialsCredentialPairArgs].
 */
@PulumiTagMarker
public class DataSourceCredentialsCredentialPairArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Password, maximum length of 1024 characters.
     */
    @JvmName("dvhryjjtlpvsnene")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value User name, maximum length of 64 characters.
     */
    @JvmName("paskjvkiyuwfqqoi")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Password, maximum length of 1024 characters.
     */
    @JvmName("lknejhdtrwgeichm")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value User name, maximum length of 64 characters.
     */
    @JvmName("enakwandqwjjgyfh")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): DataSourceCredentialsCredentialPairArgs =
        DataSourceCredentialsCredentialPairArgs(
            password = password ?: throw PulumiNullFieldException("password"),
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
