@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersAmazonElasticsearchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domain The OpenSearch domain.
 */
public data class DataSourceParametersAmazonElasticsearchArgs(
    public val domain: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersAmazonElasticsearchArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersAmazonElasticsearchArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersAmazonElasticsearchArgs.builder()
            .domain(domain.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersAmazonElasticsearchArgs].
 */
@PulumiTagMarker
public class DataSourceParametersAmazonElasticsearchArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    /**
     * @param value The OpenSearch domain.
     */
    @JvmName("mufpdpctvnrjgsgb")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The OpenSearch domain.
     */
    @JvmName("bhojaacbwjyxfkpc")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    internal fun build(): DataSourceParametersAmazonElasticsearchArgs =
        DataSourceParametersAmazonElasticsearchArgs(
            domain = domain ?: throw PulumiNullFieldException("domain"),
        )
}
