@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersAthenaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property workGroup The work-group to which to connect.
 */
public data class DataSourceParametersAthenaArgs(
    public val workGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersAthenaArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersAthenaArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersAthenaArgs.builder()
            .workGroup(workGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersAthenaArgs].
 */
@PulumiTagMarker
public class DataSourceParametersAthenaArgsBuilder internal constructor() {
    private var workGroup: Output<String>? = null

    /**
     * @param value The work-group to which to connect.
     */
    @JvmName("cyrfvmeopsqhgqvu")
    public suspend fun workGroup(`value`: Output<String>) {
        this.workGroup = value
    }

    /**
     * @param value The work-group to which to connect.
     */
    @JvmName("mqmehixbbqukirgf")
    public suspend fun workGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workGroup = mapped
    }

    internal fun build(): DataSourceParametersAthenaArgs = DataSourceParametersAthenaArgs(
        workGroup = workGroup,
    )
}
