@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersRdsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property database The database to which to connect.
 * @property instanceId The instance ID to which to connect.
 */
public data class DataSourceParametersRdsArgs(
    public val database: Output<String>,
    public val instanceId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersRdsArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersRdsArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersRdsArgs.builder()
            .database(database.applyValue({ args0 -> args0 }))
            .instanceId(instanceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersRdsArgs].
 */
@PulumiTagMarker
public class DataSourceParametersRdsArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value The database to which to connect.
     */
    @JvmName("lffvwkqqecvmyqhx")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The instance ID to which to connect.
     */
    @JvmName("gxbxpfvqkfpydmrs")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The database to which to connect.
     */
    @JvmName("owreayompwolhjby")
    public suspend fun database(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The instance ID to which to connect.
     */
    @JvmName("xlqgjixtnpqoipmm")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): DataSourceParametersRdsArgs = DataSourceParametersRdsArgs(
        database = database ?: throw PulumiNullFieldException("database"),
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
    )
}
