@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersRedshiftArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterId The ID of the cluster to which to connect.
 * @property database The database to which to connect.
 * @property host The host to which to connect.
 * @property port The port to which to connect.
 */
public data class DataSourceParametersRedshiftArgs(
    public val clusterId: Output<String>? = null,
    public val database: Output<String>,
    public val host: Output<String>? = null,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersRedshiftArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersRedshiftArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersRedshiftArgs.builder()
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .database(database.applyValue({ args0 -> args0 }))
            .host(host?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersRedshiftArgs].
 */
@PulumiTagMarker
public class DataSourceParametersRedshiftArgsBuilder internal constructor() {
    private var clusterId: Output<String>? = null

    private var database: Output<String>? = null

    private var host: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The ID of the cluster to which to connect.
     */
    @JvmName("dyciycrpxxukvjik")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The database to which to connect.
     */
    @JvmName("msoubownubmcrrky")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("jtkodbuvsscexuys")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The port to which to connect.
     */
    @JvmName("mgdftnemnwfbdlpa")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The ID of the cluster to which to connect.
     */
    @JvmName("kllpehuctwgargmu")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The database to which to connect.
     */
    @JvmName("fdkyibnfkjwgynue")
    public suspend fun database(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("efkcgnvinxcbqexd")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The port to which to connect.
     */
    @JvmName("gvvuxyutgwetmdqp")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): DataSourceParametersRedshiftArgs = DataSourceParametersRedshiftArgs(
        clusterId = clusterId,
        database = database ?: throw PulumiNullFieldException("database"),
        host = host,
        port = port,
    )
}
