@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property manifestFileLocation An object containing the S3 location of the S3 manifest file.
 */
public data class DataSourceParametersS3Args(
    public val manifestFileLocation: Output<DataSourceParametersS3ManifestFileLocationArgs>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersS3Args> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersS3Args =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersS3Args.builder()
            .manifestFileLocation(
                manifestFileLocation.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSourceParametersS3Args].
 */
@PulumiTagMarker
public class DataSourceParametersS3ArgsBuilder internal constructor() {
    private var manifestFileLocation: Output<DataSourceParametersS3ManifestFileLocationArgs>? = null

    /**
     * @param value An object containing the S3 location of the S3 manifest file.
     */
    @JvmName("klkmmavgsnacvmxw")
    public suspend fun manifestFileLocation(`value`: Output<DataSourceParametersS3ManifestFileLocationArgs>) {
        this.manifestFileLocation = value
    }

    /**
     * @param value An object containing the S3 location of the S3 manifest file.
     */
    @JvmName("euwephdodrlkpgmc")
    public suspend fun manifestFileLocation(`value`: DataSourceParametersS3ManifestFileLocationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestFileLocation = mapped
    }

    /**
     * @param argument An object containing the S3 location of the S3 manifest file.
     */
    @JvmName("fmtfulrpahtcjawg")
    public suspend fun manifestFileLocation(argument: suspend DataSourceParametersS3ManifestFileLocationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersS3ManifestFileLocationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.manifestFileLocation = mapped
    }

    internal fun build(): DataSourceParametersS3Args = DataSourceParametersS3Args(
        manifestFileLocation = manifestFileLocation ?: throw
            PulumiNullFieldException("manifestFileLocation"),
    )
}
