@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersSparkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property host The host to which to connect.
 * @property port The warehouse to which to connect.
 */
public data class DataSourceParametersSparkArgs(
    public val host: Output<String>,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersSparkArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersSparkArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersSparkArgs.builder()
            .host(host.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersSparkArgs].
 */
@PulumiTagMarker
public class DataSourceParametersSparkArgsBuilder internal constructor() {
    private var host: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The host to which to connect.
     */
    @JvmName("xwyntaiwoccepuwv")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The warehouse to which to connect.
     */
    @JvmName("osenjtppthwwpgyc")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("cgviwlghmjyxtbhl")
    public suspend fun host(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The warehouse to which to connect.
     */
    @JvmName("mplckpexhgnhciho")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): DataSourceParametersSparkArgs = DataSourceParametersSparkArgs(
        host = host ?: throw PulumiNullFieldException("host"),
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
