@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersTwitterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxRows The maximum number of rows to query.
 * @property query The Twitter query to retrieve the data.
 */
public data class DataSourceParametersTwitterArgs(
    public val maxRows: Output<Int>,
    public val query: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersTwitterArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersTwitterArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersTwitterArgs.builder()
            .maxRows(maxRows.applyValue({ args0 -> args0 }))
            .query(query.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersTwitterArgs].
 */
@PulumiTagMarker
public class DataSourceParametersTwitterArgsBuilder internal constructor() {
    private var maxRows: Output<Int>? = null

    private var query: Output<String>? = null

    /**
     * @param value The maximum number of rows to query.
     */
    @JvmName("udvetcdpgfqwfrjq")
    public suspend fun maxRows(`value`: Output<Int>) {
        this.maxRows = value
    }

    /**
     * @param value The Twitter query to retrieve the data.
     */
    @JvmName("akuavhwtjjlyelrn")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The maximum number of rows to query.
     */
    @JvmName("jitcfnslmfmhwkgy")
    public suspend fun maxRows(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRows = mapped
    }

    /**
     * @param value The Twitter query to retrieve the data.
     */
    @JvmName("aortcatndnosjsoq")
    public suspend fun query(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.query = mapped
    }

    internal fun build(): DataSourceParametersTwitterArgs = DataSourceParametersTwitterArgs(
        maxRows = maxRows ?: throw PulumiNullFieldException("maxRows"),
        query = query ?: throw PulumiNullFieldException("query"),
    )
}
