@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceVpcConnectionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property vpcConnectionArn The Amazon Resource Name (ARN) for the VPC connection.
 */
public data class DataSourceVpcConnectionPropertiesArgs(
    public val vpcConnectionArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceVpcConnectionPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceVpcConnectionPropertiesArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceVpcConnectionPropertiesArgs.builder()
            .vpcConnectionArn(vpcConnectionArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceVpcConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class DataSourceVpcConnectionPropertiesArgsBuilder internal constructor() {
    private var vpcConnectionArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) for the VPC connection.
     */
    @JvmName("oiiabmjghrdewmtf")
    public suspend fun vpcConnectionArn(`value`: Output<String>) {
        this.vpcConnectionArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the VPC connection.
     */
    @JvmName("ekpmjniyqlbcwsof")
    public suspend fun vpcConnectionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcConnectionArn = mapped
    }

    internal fun build(): DataSourceVpcConnectionPropertiesArgs =
        DataSourceVpcConnectionPropertiesArgs(
            vpcConnectionArn = vpcConnectionArn ?: throw PulumiNullFieldException("vpcConnectionArn"),
        )
}
