@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.GetQuicksightUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQuicksightUser.
 * @property awsAccountId AWS account ID.
 * @property namespace QuickSight namespace. Defaults to `default`.
 * @property userName The name of the user that you want to match.
 * The following arguments are optional:
 */
public data class GetQuicksightUserPlainArgs(
    public val awsAccountId: String? = null,
    public val namespace: String? = null,
    public val userName: String,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.GetQuicksightUserPlainArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.GetQuicksightUserPlainArgs =
        com.pulumi.aws.quicksight.inputs.GetQuicksightUserPlainArgs.builder()
            .awsAccountId(awsAccountId?.let({ args0 -> args0 }))
            .namespace(namespace?.let({ args0 -> args0 }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQuicksightUserPlainArgs].
 */
@PulumiTagMarker
public class GetQuicksightUserPlainArgsBuilder internal constructor() {
    private var awsAccountId: String? = null

    private var namespace: String? = null

    private var userName: String? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("hbinljmfdtvovhhi")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.awsAccountId = mapped
    }

    /**
     * @param value QuickSight namespace. Defaults to `default`.
     */
    @JvmName("djxhsxcjplnsfwxh")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespace = mapped
    }

    /**
     * @param value The name of the user that you want to match.
     * The following arguments are optional:
     */
    @JvmName("ygngofbmyodojbir")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetQuicksightUserPlainArgs = GetQuicksightUserPlainArgs(
        awsAccountId = awsAccountId,
        namespace = namespace,
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
