@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property refreshType The type of refresh that the dataset undergoes. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
 * @property scheduleFrequency The configuration of the [schedule frequency](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshFrequency.html). See schedule_frequency.
 * @property startAfterDateTime Time after which the refresh schedule can be started, expressed in `YYYY-MM-DDTHH:MM:SS` format.
 */
public data class RefreshScheduleScheduleArgs(
    public val refreshType: Output<String>,
    public val scheduleFrequency: Output<RefreshScheduleScheduleScheduleFrequencyArgs>? = null,
    public val startAfterDateTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs =
        com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs.builder()
            .refreshType(refreshType.applyValue({ args0 -> args0 }))
            .scheduleFrequency(scheduleFrequency?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startAfterDateTime(startAfterDateTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RefreshScheduleScheduleArgs].
 */
@PulumiTagMarker
public class RefreshScheduleScheduleArgsBuilder internal constructor() {
    private var refreshType: Output<String>? = null

    private var scheduleFrequency: Output<RefreshScheduleScheduleScheduleFrequencyArgs>? = null

    private var startAfterDateTime: Output<String>? = null

    /**
     * @param value The type of refresh that the dataset undergoes. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
     */
    @JvmName("hmhyrgeqocqkkssp")
    public suspend fun refreshType(`value`: Output<String>) {
        this.refreshType = value
    }

    /**
     * @param value The configuration of the [schedule frequency](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshFrequency.html). See schedule_frequency.
     */
    @JvmName("fovydnkokixitlej")
    public suspend fun scheduleFrequency(`value`: Output<RefreshScheduleScheduleScheduleFrequencyArgs>) {
        this.scheduleFrequency = value
    }

    /**
     * @param value Time after which the refresh schedule can be started, expressed in `YYYY-MM-DDTHH:MM:SS` format.
     */
    @JvmName("gkwwbiqtwdiaoicu")
    public suspend fun startAfterDateTime(`value`: Output<String>) {
        this.startAfterDateTime = value
    }

    /**
     * @param value The type of refresh that the dataset undergoes. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
     */
    @JvmName("odgsagxrdbrkcfqe")
    public suspend fun refreshType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshType = mapped
    }

    /**
     * @param value The configuration of the [schedule frequency](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshFrequency.html). See schedule_frequency.
     */
    @JvmName("nqfafutwicajxmad")
    public suspend fun scheduleFrequency(`value`: RefreshScheduleScheduleScheduleFrequencyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleFrequency = mapped
    }

    /**
     * @param argument The configuration of the [schedule frequency](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshFrequency.html). See schedule_frequency.
     */
    @JvmName("eildweukohrfyylc")
    public suspend fun scheduleFrequency(argument: suspend RefreshScheduleScheduleScheduleFrequencyArgsBuilder.() -> Unit) {
        val toBeMapped = RefreshScheduleScheduleScheduleFrequencyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scheduleFrequency = mapped
    }

    /**
     * @param value Time after which the refresh schedule can be started, expressed in `YYYY-MM-DDTHH:MM:SS` format.
     */
    @JvmName("nebhjsyijwwyjvih")
    public suspend fun startAfterDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startAfterDateTime = mapped
    }

    internal fun build(): RefreshScheduleScheduleArgs = RefreshScheduleScheduleArgs(
        refreshType = refreshType ?: throw PulumiNullFieldException("refreshType"),
        scheduleFrequency = scheduleFrequency,
        startAfterDateTime = startAfterDateTime,
    )
}
