@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dayOfMonth The day of the month that you want to schedule refresh on.
 * @property dayOfWeek The day of the week that you want to schedule a refresh on. Valid values are `SUNDAY`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY` and `SATURDAY`.
 */
public data class RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs(
    public val dayOfMonth: Output<String>? = null,
    public val dayOfWeek: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs =
        com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder()
            .dayOfMonth(dayOfMonth?.applyValue({ args0 -> args0 }))
            .dayOfWeek(dayOfWeek?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs].
 */
@PulumiTagMarker
public class RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgsBuilder internal constructor() {
    private var dayOfMonth: Output<String>? = null

    private var dayOfWeek: Output<String>? = null

    /**
     * @param value The day of the month that you want to schedule refresh on.
     */
    @JvmName("joqalgdfiifsiouk")
    public suspend fun dayOfMonth(`value`: Output<String>) {
        this.dayOfMonth = value
    }

    /**
     * @param value The day of the week that you want to schedule a refresh on. Valid values are `SUNDAY`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY` and `SATURDAY`.
     */
    @JvmName("ggfmjwtteanogtlp")
    public suspend fun dayOfWeek(`value`: Output<String>) {
        this.dayOfWeek = value
    }

    /**
     * @param value The day of the month that you want to schedule refresh on.
     */
    @JvmName("bitigylnokmotwyn")
    public suspend fun dayOfMonth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dayOfMonth = mapped
    }

    /**
     * @param value The day of the week that you want to schedule a refresh on. Valid values are `SUNDAY`, `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY` and `SATURDAY`.
     */
    @JvmName("awfawqncpdurprpv")
    public suspend fun dayOfWeek(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    internal fun build(): RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs =
        RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs(
            dayOfMonth = dayOfMonth,
            dayOfWeek = dayOfWeek,
        )
}
