@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationDataColorPaletteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property colors List of hexadecimal codes for the colors. Minimum of 8 items and maximum of 20 items.
 * @property emptyFillColor The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
 * @property minMaxGradients The minimum and maximum hexadecimal codes that describe a color gradient. List of exactly 2 items.
 */
public data class ThemeConfigurationDataColorPaletteArgs(
    public val colors: Output<List<String>>? = null,
    public val emptyFillColor: Output<String>? = null,
    public val minMaxGradients: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationDataColorPaletteArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationDataColorPaletteArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationDataColorPaletteArgs.builder()
            .colors(colors?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .emptyFillColor(emptyFillColor?.applyValue({ args0 -> args0 }))
            .minMaxGradients(minMaxGradients?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ThemeConfigurationDataColorPaletteArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationDataColorPaletteArgsBuilder internal constructor() {
    private var colors: Output<List<String>>? = null

    private var emptyFillColor: Output<String>? = null

    private var minMaxGradients: Output<List<String>>? = null

    /**
     * @param value List of hexadecimal codes for the colors. Minimum of 8 items and maximum of 20 items.
     */
    @JvmName("goujboilslopgphe")
    public suspend fun colors(`value`: Output<List<String>>) {
        this.colors = value
    }

    @JvmName("myabrbvxyedtpfpl")
    public suspend fun colors(vararg values: Output<String>) {
        this.colors = Output.all(values.asList())
    }

    /**
     * @param values List of hexadecimal codes for the colors. Minimum of 8 items and maximum of 20 items.
     */
    @JvmName("hptxtoxeftgsqewu")
    public suspend fun colors(values: List<Output<String>>) {
        this.colors = Output.all(values)
    }

    /**
     * @param value The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
     */
    @JvmName("hljcpegkvwyrlbrt")
    public suspend fun emptyFillColor(`value`: Output<String>) {
        this.emptyFillColor = value
    }

    /**
     * @param value The minimum and maximum hexadecimal codes that describe a color gradient. List of exactly 2 items.
     */
    @JvmName("qoqcomlprvwabfkq")
    public suspend fun minMaxGradients(`value`: Output<List<String>>) {
        this.minMaxGradients = value
    }

    @JvmName("mprqyoyxsgnwmwlt")
    public suspend fun minMaxGradients(vararg values: Output<String>) {
        this.minMaxGradients = Output.all(values.asList())
    }

    /**
     * @param values The minimum and maximum hexadecimal codes that describe a color gradient. List of exactly 2 items.
     */
    @JvmName("kbqgrcqgbufxrtun")
    public suspend fun minMaxGradients(values: List<Output<String>>) {
        this.minMaxGradients = Output.all(values)
    }

    /**
     * @param value List of hexadecimal codes for the colors. Minimum of 8 items and maximum of 20 items.
     */
    @JvmName("eysycyqioyqvehwp")
    public suspend fun colors(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.colors = mapped
    }

    /**
     * @param values List of hexadecimal codes for the colors. Minimum of 8 items and maximum of 20 items.
     */
    @JvmName("rmteqvyusruujbuw")
    public suspend fun colors(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.colors = mapped
    }

    /**
     * @param value The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
     */
    @JvmName("ucvhtphhwjhlknte")
    public suspend fun emptyFillColor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emptyFillColor = mapped
    }

    /**
     * @param value The minimum and maximum hexadecimal codes that describe a color gradient. List of exactly 2 items.
     */
    @JvmName("budegniwidxelion")
    public suspend fun minMaxGradients(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minMaxGradients = mapped
    }

    /**
     * @param values The minimum and maximum hexadecimal codes that describe a color gradient. List of exactly 2 items.
     */
    @JvmName("dsmroejfirnpgetp")
    public suspend fun minMaxGradients(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minMaxGradients = mapped
    }

    internal fun build(): ThemeConfigurationDataColorPaletteArgs =
        ThemeConfigurationDataColorPaletteArgs(
            colors = colors,
            emptyFillColor = emptyFillColor,
            minMaxGradients = minMaxGradients,
        )
}
