@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property tile The display options for tiles. See tile.
 * @property tileLayout The layout options for tiles. See tile_layout.
 */
public data class ThemeConfigurationSheetArgs(
    public val tile: Output<ThemeConfigurationSheetTileArgs>? = null,
    public val tileLayout: Output<ThemeConfigurationSheetTileLayoutArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetArgs.builder()
            .tile(tile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tileLayout(tileLayout?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ThemeConfigurationSheetArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationSheetArgsBuilder internal constructor() {
    private var tile: Output<ThemeConfigurationSheetTileArgs>? = null

    private var tileLayout: Output<ThemeConfigurationSheetTileLayoutArgs>? = null

    /**
     * @param value The display options for tiles. See tile.
     */
    @JvmName("gdguknedupnmvnyc")
    public suspend fun tile(`value`: Output<ThemeConfigurationSheetTileArgs>) {
        this.tile = value
    }

    /**
     * @param value The layout options for tiles. See tile_layout.
     */
    @JvmName("ljvloepwhcmofayd")
    public suspend fun tileLayout(`value`: Output<ThemeConfigurationSheetTileLayoutArgs>) {
        this.tileLayout = value
    }

    /**
     * @param value The display options for tiles. See tile.
     */
    @JvmName("mqejdpjyeoyyrldo")
    public suspend fun tile(`value`: ThemeConfigurationSheetTileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tile = mapped
    }

    /**
     * @param argument The display options for tiles. See tile.
     */
    @JvmName("gwmakqqqtvghaqfv")
    public suspend fun tile(argument: suspend ThemeConfigurationSheetTileArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationSheetTileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tile = mapped
    }

    /**
     * @param value The layout options for tiles. See tile_layout.
     */
    @JvmName("ywxufpdndeqgdviu")
    public suspend fun tileLayout(`value`: ThemeConfigurationSheetTileLayoutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tileLayout = mapped
    }

    /**
     * @param argument The layout options for tiles. See tile_layout.
     */
    @JvmName("piyflkxtttsyphtj")
    public suspend fun tileLayout(argument: suspend ThemeConfigurationSheetTileLayoutArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationSheetTileLayoutArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tileLayout = mapped
    }

    internal fun build(): ThemeConfigurationSheetArgs = ThemeConfigurationSheetArgs(
        tile = tile,
        tileLayout = tileLayout,
    )
}
