@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property border The border around a tile. See border.
 */
public data class ThemeConfigurationSheetTileArgs(
    public val border: Output<ThemeConfigurationSheetTileBorderArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileArgs.builder()
            .border(border?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ThemeConfigurationSheetTileArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationSheetTileArgsBuilder internal constructor() {
    private var border: Output<ThemeConfigurationSheetTileBorderArgs>? = null

    /**
     * @param value The border around a tile. See border.
     */
    @JvmName("jacqcdkkydwmesll")
    public suspend fun border(`value`: Output<ThemeConfigurationSheetTileBorderArgs>) {
        this.border = value
    }

    /**
     * @param value The border around a tile. See border.
     */
    @JvmName("qisvnrggpdfhrqyi")
    public suspend fun border(`value`: ThemeConfigurationSheetTileBorderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.border = mapped
    }

    /**
     * @param argument The border around a tile. See border.
     */
    @JvmName("odpvihnigwfrjggh")
    public suspend fun border(argument: suspend ThemeConfigurationSheetTileBorderArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationSheetTileBorderArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.border = mapped
    }

    internal fun build(): ThemeConfigurationSheetTileArgs = ThemeConfigurationSheetTileArgs(
        border = border,
    )
}
