@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileBorderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property show The option to enable display of borders for visuals.
 */
public data class ThemeConfigurationSheetTileBorderArgs(
    public val show: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileBorderArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileBorderArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileBorderArgs.builder()
            .show(show?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThemeConfigurationSheetTileBorderArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationSheetTileBorderArgsBuilder internal constructor() {
    private var show: Output<Boolean>? = null

    /**
     * @param value The option to enable display of borders for visuals.
     */
    @JvmName("kdhfwmqlunedvhfv")
    public suspend fun show(`value`: Output<Boolean>) {
        this.show = value
    }

    /**
     * @param value The option to enable display of borders for visuals.
     */
    @JvmName("xmojytwritdbpyqc")
    public suspend fun show(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.show = mapped
    }

    internal fun build(): ThemeConfigurationSheetTileBorderArgs =
        ThemeConfigurationSheetTileBorderArgs(
            show = show,
        )
}
