@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileLayoutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property gutter The gutter settings that apply between tiles. See gutter.
 * @property margin The margin settings that apply around the outside edge of sheets. See margin.
 */
public data class ThemeConfigurationSheetTileLayoutArgs(
    public val gutter: Output<ThemeConfigurationSheetTileLayoutGutterArgs>? = null,
    public val margin: Output<ThemeConfigurationSheetTileLayoutMarginArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileLayoutArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileLayoutArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileLayoutArgs.builder()
            .gutter(gutter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .margin(margin?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ThemeConfigurationSheetTileLayoutArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationSheetTileLayoutArgsBuilder internal constructor() {
    private var gutter: Output<ThemeConfigurationSheetTileLayoutGutterArgs>? = null

    private var margin: Output<ThemeConfigurationSheetTileLayoutMarginArgs>? = null

    /**
     * @param value The gutter settings that apply between tiles. See gutter.
     */
    @JvmName("qnucrcynevgykuus")
    public suspend fun gutter(`value`: Output<ThemeConfigurationSheetTileLayoutGutterArgs>) {
        this.gutter = value
    }

    /**
     * @param value The margin settings that apply around the outside edge of sheets. See margin.
     */
    @JvmName("tcbuhbebivwilrlg")
    public suspend fun margin(`value`: Output<ThemeConfigurationSheetTileLayoutMarginArgs>) {
        this.margin = value
    }

    /**
     * @param value The gutter settings that apply between tiles. See gutter.
     */
    @JvmName("bnonqwuqhhnbqqkr")
    public suspend fun gutter(`value`: ThemeConfigurationSheetTileLayoutGutterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gutter = mapped
    }

    /**
     * @param argument The gutter settings that apply between tiles. See gutter.
     */
    @JvmName("xrmieaudtfgrsohh")
    public suspend fun gutter(argument: suspend ThemeConfigurationSheetTileLayoutGutterArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationSheetTileLayoutGutterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.gutter = mapped
    }

    /**
     * @param value The margin settings that apply around the outside edge of sheets. See margin.
     */
    @JvmName("abqilutdtbdsnbns")
    public suspend fun margin(`value`: ThemeConfigurationSheetTileLayoutMarginArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.margin = mapped
    }

    /**
     * @param argument The margin settings that apply around the outside edge of sheets. See margin.
     */
    @JvmName("ixwyxydxemsxmcrf")
    public suspend fun margin(argument: suspend ThemeConfigurationSheetTileLayoutMarginArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationSheetTileLayoutMarginArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.margin = mapped
    }

    internal fun build(): ThemeConfigurationSheetTileLayoutArgs =
        ThemeConfigurationSheetTileLayoutArgs(
            gutter = gutter,
            margin = margin,
        )
}
