@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileLayoutGutterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property show This Boolean value controls whether to display a gutter space between sheet tiles.
 */
public data class ThemeConfigurationSheetTileLayoutGutterArgs(
    public val show: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileLayoutGutterArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileLayoutGutterArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationSheetTileLayoutGutterArgs.builder()
            .show(show?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThemeConfigurationSheetTileLayoutGutterArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationSheetTileLayoutGutterArgsBuilder internal constructor() {
    private var show: Output<Boolean>? = null

    /**
     * @param value This Boolean value controls whether to display a gutter space between sheet tiles.
     */
    @JvmName("vewtkihrfudqflab")
    public suspend fun show(`value`: Output<Boolean>) {
        this.show = value
    }

    /**
     * @param value This Boolean value controls whether to display a gutter space between sheet tiles.
     */
    @JvmName("ljbgksfgrkfuolcb")
    public suspend fun show(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.show = mapped
    }

    internal fun build(): ThemeConfigurationSheetTileLayoutGutterArgs =
        ThemeConfigurationSheetTileLayoutGutterArgs(
            show = show,
        )
}
