@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.VpcConnectionTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
 * @property delete A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
 * @property update A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
 */
public data class VpcConnectionTimeoutsArgs(
    public val create: Output<String>? = null,
    public val delete: Output<String>? = null,
    public val update: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.VpcConnectionTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.VpcConnectionTimeoutsArgs =
        com.pulumi.aws.quicksight.inputs.VpcConnectionTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 }))
            .delete(delete?.applyValue({ args0 -> args0 }))
            .update(update?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcConnectionTimeoutsArgs].
 */
@PulumiTagMarker
public class VpcConnectionTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var delete: Output<String>? = null

    private var update: Output<String>? = null

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("caimeaxiwumjeuqv")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
     */
    @JvmName("ubxvvrhgyscpxefc")
    public suspend fun delete(`value`: Output<String>) {
        this.delete = value
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("mqmpepwfgainrkol")
    public suspend fun update(`value`: Output<String>) {
        this.update = value
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("sifnflmkcygqhixw")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
     */
    @JvmName("jtrrsnyraneolisy")
    public suspend fun delete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("voldourmlapixehf")
    public suspend fun update(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.update = mapped
    }

    internal fun build(): VpcConnectionTimeoutsArgs = VpcConnectionTimeoutsArgs(
        create = create,
        delete = delete,
        update = update,
    )
}
