@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dateTimeParameters A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
 * @property decimalParameters A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
 * @property integerParameters A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
 * @property stringParameters A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
 */
public data class DashboardParameters(
    public val dateTimeParameters: List<DashboardParametersDateTimeParameter>? = null,
    public val decimalParameters: List<DashboardParametersDecimalParameter>? = null,
    public val integerParameters: List<DashboardParametersIntegerParameter>? = null,
    public val stringParameters: List<DashboardParametersStringParameter>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DashboardParameters): DashboardParameters = DashboardParameters(
            dateTimeParameters = javaType.dateTimeParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardParametersDateTimeParameter.Companion.toKotlin(args0)
                })
            }),
            decimalParameters = javaType.decimalParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardParametersDecimalParameter.Companion.toKotlin(args0)
                })
            }),
            integerParameters = javaType.integerParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardParametersIntegerParameter.Companion.toKotlin(args0)
                })
            }),
            stringParameters = javaType.stringParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DashboardParametersStringParameter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
