@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property columnNames An array of column names.
 * @property principals An array of ARNs for Amazon QuickSight users or groups.
 */
public data class DataSetColumnLevelPermissionRule(
    public val columnNames: List<String>? = null,
    public val principals: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetColumnLevelPermissionRule): DataSetColumnLevelPermissionRule = DataSetColumnLevelPermissionRule(
            columnNames = javaType.columnNames().map({ args0 -> args0 }),
            principals = javaType.principals().map({ args0 -> args0 }),
        )
    }
}
