@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alias A display name for the logical table.
 * @property dataTransforms Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. See data_transforms.
 * @property logicalTableMapId Key of the logical table map.
 * @property source Source of this logical table. See source.
 */
public data class DataSetLogicalTableMap(
    public val alias: String,
    public val dataTransforms: List<DataSetLogicalTableMapDataTransform>? = null,
    public val logicalTableMapId: String,
    public val source: DataSetLogicalTableMapSource,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetLogicalTableMap): DataSetLogicalTableMap = DataSetLogicalTableMap(
            alias = javaType.alias(),
            dataTransforms = javaType.dataTransforms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapDataTransform.Companion.toKotlin(args0)
                })
            }),
            logicalTableMapId = javaType.logicalTableMapId(),
            source = javaType.source().let({ args0 ->
                com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapSource.Companion.toKotlin(args0)
            }),
        )
    }
}
