@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property leftJoinKeyProperties Join key properties of the left operand. See left_join_key_properties.
 * @property leftOperand Operand on the left side of a join.
 * @property onClause Join instructions provided in the ON clause of a join.
 * @property rightJoinKeyProperties Join key properties of the right operand. See right_join_key_properties.
 * @property rightOperand Operand on the right side of a join.
 * @property type Type of join. Valid values are `INNER`, `OUTER`, `LEFT`, and `RIGHT`.
 */
public data class DataSetLogicalTableMapSourceJoinInstruction(
    public val leftJoinKeyProperties: DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyProperties? = null,
    public val leftOperand: String,
    public val onClause: String,
    public val rightJoinKeyProperties: DataSetLogicalTableMapSourceJoinInstructionRightJoinKeyProperties? = null,
    public val rightOperand: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetLogicalTableMapSourceJoinInstruction): DataSetLogicalTableMapSourceJoinInstruction = DataSetLogicalTableMapSourceJoinInstruction(
            leftJoinKeyProperties = javaType.leftJoinKeyProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
            leftOperand = javaType.leftOperand(),
            onClause = javaType.onClause(),
            rightJoinKeyProperties = javaType.rightJoinKeyProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMapSourceJoinInstructionRightJoinKeyProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rightOperand = javaType.rightOperand(),
            type = javaType.type(),
        )
    }
}
