@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property uniqueKey A value that indicates that a row in a table is uniquely identified by the columns in a join key. This is used by Amazon QuickSight to optimize query performance.
 */
public data class DataSetLogicalTableMapSourceJoinInstructionRightJoinKeyProperties(
    public val uniqueKey: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetLogicalTableMapSourceJoinInstructionRightJoinKeyProperties): DataSetLogicalTableMapSourceJoinInstructionRightJoinKeyProperties =
            DataSetLogicalTableMapSourceJoinInstructionRightJoinKeyProperties(
                uniqueKey = javaType.uniqueKey().map({ args0 -> args0 }).orElse(null),
            )
    }
}
