@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actions List of IAM actions to grant or revoke permissions on.
 * @property principal ARN of the principal. See the [ResourcePermission documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ResourcePermission.html) for the applicable ARN values.
 */
public data class DataSetPermission(
    public val actions: List<String>,
    public val principal: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetPermission): DataSetPermission = DataSetPermission(
            actions = javaType.actions().map({ args0 -> args0 }),
            principal = javaType.principal(),
        )
    }
}
