@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property columns Column schema from the SQL query result set. See columns.
 * @property dataSourceArn ARN of the data source.
 * @property name Display name for the SQL query result.
 * @property sqlQuery SQL query.
 */
public data class DataSetPhysicalTableMapCustomSql(
    public val columns: List<DataSetPhysicalTableMapCustomSqlColumn>? = null,
    public val dataSourceArn: String,
    public val name: String,
    public val sqlQuery: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetPhysicalTableMapCustomSql): DataSetPhysicalTableMapCustomSql = DataSetPhysicalTableMapCustomSql(
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetPhysicalTableMapCustomSqlColumn.Companion.toKotlin(args0)
                })
            }),
            dataSourceArn = javaType.dataSourceArn(),
            name = javaType.name(),
            sqlQuery = javaType.sqlQuery(),
        )
    }
}
