@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property catalog Catalog associated with the table.
 * @property dataSourceArn ARN of the data source.
 * @property inputColumns Column schema of the table. See input_columns.
 * @property name Name of the relational table.
 * @property schema Schema name. This name applies to certain relational database engines.
 */
public data class DataSetPhysicalTableMapRelationalTable(
    public val catalog: String? = null,
    public val dataSourceArn: String,
    public val inputColumns: List<DataSetPhysicalTableMapRelationalTableInputColumn>,
    public val name: String,
    public val schema: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetPhysicalTableMapRelationalTable): DataSetPhysicalTableMapRelationalTable = DataSetPhysicalTableMapRelationalTable(
            catalog = javaType.catalog().map({ args0 -> args0 }).orElse(null),
            dataSourceArn = javaType.dataSourceArn(),
            inputColumns = javaType.inputColumns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSetPhysicalTableMapRelationalTableInputColumn.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
        )
    }
}
