@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property columnName Column name that a tag key is assigned to.
 * @property matchAllValue A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one.
 * @property tagKey Unique key for a tag.
 * @property tagMultiValueDelimiter A string that you want to use to delimit the values when you pass the values at run time.
 */
public data class DataSetRowLevelPermissionTagConfigurationTagRule(
    public val columnName: String,
    public val matchAllValue: String? = null,
    public val tagKey: String,
    public val tagMultiValueDelimiter: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSetRowLevelPermissionTagConfigurationTagRule): DataSetRowLevelPermissionTagConfigurationTagRule =
            DataSetRowLevelPermissionTagConfigurationTagRule(
                columnName = javaType.columnName(),
                matchAllValue = javaType.matchAllValue().map({ args0 -> args0 }).orElse(null),
                tagKey = javaType.tagKey(),
                tagMultiValueDelimiter = javaType.tagMultiValueDelimiter().map({ args0 -> args0 }).orElse(null),
            )
    }
}
