@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property copySourceArn The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use.
 * When the value is not null, the `credential_pair` from the data source in the ARN is used.
 * @property credentialPair Credential pair. See Credential Pair below for more details.
 */
public data class DataSourceCredentials(
    public val copySourceArn: String? = null,
    public val credentialPair: DataSourceCredentialsCredentialPair? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSourceCredentials): DataSourceCredentials = DataSourceCredentials(
            copySourceArn = javaType.copySourceArn().map({ args0 -> args0 }).orElse(null),
            credentialPair = javaType.credentialPair().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceCredentialsCredentialPair.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
