@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property password Password, maximum length of 1024 characters.
 * @property username User name, maximum length of 64 characters.
 */
public data class DataSourceCredentialsCredentialPair(
    public val password: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSourceCredentialsCredentialPair): DataSourceCredentialsCredentialPair = DataSourceCredentialsCredentialPair(
            password = javaType.password(),
            username = javaType.username(),
        )
    }
}
