@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property amazonElasticsearch Parameters for connecting to Amazon Elasticsearch.
 * @property athena Parameters for connecting to Athena.
 * @property aurora Parameters for connecting to Aurora MySQL.
 * @property auroraPostgresql Parameters for connecting to Aurora Postgresql.
 * @property awsIotAnalytics Parameters for connecting to AWS IOT Analytics.
 * @property jira Parameters for connecting to Jira.
 * @property mariaDb Parameters for connecting to MariaDB.
 * @property mysql Parameters for connecting to MySQL.
 * @property oracle Parameters for connecting to Oracle.
 * @property postgresql Parameters for connecting to Postgresql.
 * @property presto Parameters for connecting to Presto.
 * @property rds Parameters for connecting to RDS.
 * @property redshift Parameters for connecting to Redshift.
 * @property s3 Parameters for connecting to S3.
 * @property serviceNow Parameters for connecting to ServiceNow.
 * @property snowflake Parameters for connecting to Snowflake.
 * @property spark Parameters for connecting to Spark.
 * @property sqlServer Parameters for connecting to SQL Server.
 * @property teradata Parameters for connecting to Teradata.
 * @property twitter Parameters for connecting to Twitter.
 */
public data class DataSourceParameters(
    public val amazonElasticsearch: DataSourceParametersAmazonElasticsearch? = null,
    public val athena: DataSourceParametersAthena? = null,
    public val aurora: DataSourceParametersAurora? = null,
    public val auroraPostgresql: DataSourceParametersAuroraPostgresql? = null,
    public val awsIotAnalytics: DataSourceParametersAwsIotAnalytics? = null,
    public val jira: DataSourceParametersJira? = null,
    public val mariaDb: DataSourceParametersMariaDb? = null,
    public val mysql: DataSourceParametersMysql? = null,
    public val oracle: DataSourceParametersOracle? = null,
    public val postgresql: DataSourceParametersPostgresql? = null,
    public val presto: DataSourceParametersPresto? = null,
    public val rds: DataSourceParametersRds? = null,
    public val redshift: DataSourceParametersRedshift? = null,
    public val s3: DataSourceParametersS3? = null,
    public val serviceNow: DataSourceParametersServiceNow? = null,
    public val snowflake: DataSourceParametersSnowflake? = null,
    public val spark: DataSourceParametersSpark? = null,
    public val sqlServer: DataSourceParametersSqlServer? = null,
    public val teradata: DataSourceParametersTeradata? = null,
    public val twitter: DataSourceParametersTwitter? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSourceParameters): DataSourceParameters = DataSourceParameters(
            amazonElasticsearch = javaType.amazonElasticsearch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersAmazonElasticsearch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            athena = javaType.athena().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersAthena.Companion.toKotlin(args0)
                })
            }).orElse(null),
            aurora = javaType.aurora().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersAurora.Companion.toKotlin(args0)
                })
            }).orElse(null),
            auroraPostgresql = javaType.auroraPostgresql().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersAuroraPostgresql.Companion.toKotlin(args0)
                })
            }).orElse(null),
            awsIotAnalytics = javaType.awsIotAnalytics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersAwsIotAnalytics.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jira = javaType.jira().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersJira.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mariaDb = javaType.mariaDb().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersMariaDb.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mysql = javaType.mysql().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersMysql.Companion.toKotlin(args0)
                })
            }).orElse(null),
            oracle = javaType.oracle().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersOracle.Companion.toKotlin(args0)
                })
            }).orElse(null),
            postgresql = javaType.postgresql().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersPostgresql.Companion.toKotlin(args0)
                })
            }).orElse(null),
            presto = javaType.presto().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersPresto.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rds = javaType.rds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersRds.Companion.toKotlin(args0)
                })
            }).orElse(null),
            redshift = javaType.redshift().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersRedshift.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3 = javaType.s3().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersS3.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceNow = javaType.serviceNow().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersServiceNow.Companion.toKotlin(args0)
                })
            }).orElse(null),
            snowflake = javaType.snowflake().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersSnowflake.Companion.toKotlin(args0)
                })
            }).orElse(null),
            spark = javaType.spark().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersSpark.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqlServer = javaType.sqlServer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersSqlServer.Companion.toKotlin(args0)
                })
            }).orElse(null),
            teradata = javaType.teradata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersTeradata.Companion.toKotlin(args0)
                })
            }).orElse(null),
            twitter = javaType.twitter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParametersTwitter.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
