@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalog The catalog to which to connect.
 * @property host The host to which to connect.
 * @property port The port to which to connect.
 */
public data class DataSourceParametersPresto(
    public val catalog: String,
    public val host: String,
    public val port: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSourceParametersPresto): DataSourceParametersPresto = DataSourceParametersPresto(
            catalog = javaType.catalog(),
            host = javaType.host(),
            port = javaType.port(),
        )
    }
}
