@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterId The ID of the cluster to which to connect.
 * @property database The database to which to connect.
 * @property host The host to which to connect.
 * @property port The port to which to connect.
 */
public data class DataSourceParametersRedshift(
    public val clusterId: String? = null,
    public val database: String,
    public val host: String? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.DataSourceParametersRedshift): DataSourceParametersRedshift = DataSourceParametersRedshift(
            clusterId = javaType.clusterId().map({ args0 -> args0 }).orElse(null),
            database = javaType.database(),
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
