@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alias
 * @property dataTransforms
 * @property logicalTableMapId
 * @property sources
 */
public data class GetDataSetLogicalTableMap(
    public val alias: String,
    public val dataTransforms: List<GetDataSetLogicalTableMapDataTransform>,
    public val logicalTableMapId: String,
    public val sources: List<GetDataSetLogicalTableMapSource>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetDataSetLogicalTableMap): GetDataSetLogicalTableMap = GetDataSetLogicalTableMap(
            alias = javaType.alias(),
            dataTransforms = javaType.dataTransforms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetLogicalTableMapDataTransform.Companion.toKotlin(args0)
                })
            }),
            logicalTableMapId = javaType.logicalTableMapId(),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetLogicalTableMapSource.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
