@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customSqls
 * @property physicalTableMapId
 * @property relationalTables
 * @property s3Sources
 */
public data class GetDataSetPhysicalTableMap(
    public val customSqls: List<GetDataSetPhysicalTableMapCustomSql>,
    public val physicalTableMapId: String,
    public val relationalTables: List<GetDataSetPhysicalTableMapRelationalTable>,
    public val s3Sources: List<GetDataSetPhysicalTableMapS3Source>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.GetDataSetPhysicalTableMap): GetDataSetPhysicalTableMap = GetDataSetPhysicalTableMap(
            customSqls = javaType.customSqls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetPhysicalTableMapCustomSql.Companion.toKotlin(args0)
                })
            }),
            physicalTableMapId = javaType.physicalTableMapId(),
            relationalTables = javaType.relationalTables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetPhysicalTableMapRelationalTable.Companion.toKotlin(args0)
                })
            }),
            s3Sources = javaType.s3Sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetPhysicalTableMapS3Source.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
