@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the resource.
 * @property dataSetReferences A list of dataset references used as placeholders in the template. See data_set_references.
 */
public data class TemplateSourceEntitySourceAnalysis(
    public val arn: String,
    public val dataSetReferences: List<TemplateSourceEntitySourceAnalysisDataSetReference>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.TemplateSourceEntitySourceAnalysis): TemplateSourceEntitySourceAnalysis = TemplateSourceEntitySourceAnalysis(
            arn = javaType.arn(),
            dataSetReferences = javaType.dataSetReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.TemplateSourceEntitySourceAnalysisDataSetReference.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
