@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property dataColorPalette Color properties that apply to chart data colors. See data_color_palette.
 * @property sheet Display options related to sheets. See sheet.
 * @property typography Determines the typography options. See typography.
 * @property uiColorPalette Color properties that apply to the UI and to charts, excluding the colors that apply to data. See ui_color_palette.
 */
public data class ThemeConfiguration(
    public val dataColorPalette: ThemeConfigurationDataColorPalette? = null,
    public val sheet: ThemeConfigurationSheet? = null,
    public val typography: ThemeConfigurationTypography? = null,
    public val uiColorPalette: ThemeConfigurationUiColorPalette? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.ThemeConfiguration): ThemeConfiguration = ThemeConfiguration(
            dataColorPalette = javaType.dataColorPalette().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfigurationDataColorPalette.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sheet = javaType.sheet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfigurationSheet.Companion.toKotlin(args0)
                })
            }).orElse(null),
            typography = javaType.typography().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfigurationTypography.Companion.toKotlin(args0)
                })
            }).orElse(null),
            uiColorPalette = javaType.uiColorPalette().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfigurationUiColorPalette.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
