@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property colors List of hexadecimal codes for the colors. Minimum of 8 items and maximum of 20 items.
 * @property emptyFillColor The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
 * @property minMaxGradients The minimum and maximum hexadecimal codes that describe a color gradient. List of exactly 2 items.
 */
public data class ThemeConfigurationDataColorPalette(
    public val colors: List<String>? = null,
    public val emptyFillColor: String? = null,
    public val minMaxGradients: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.ThemeConfigurationDataColorPalette): ThemeConfigurationDataColorPalette = ThemeConfigurationDataColorPalette(
            colors = javaType.colors().map({ args0 -> args0 }),
            emptyFillColor = javaType.emptyFillColor().map({ args0 -> args0 }).orElse(null),
            minMaxGradients = javaType.minMaxGradients().map({ args0 -> args0 }),
        )
    }
}
