@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property tile The display options for tiles. See tile.
 * @property tileLayout The layout options for tiles. See tile_layout.
 */
public data class ThemeConfigurationSheet(
    public val tile: ThemeConfigurationSheetTile? = null,
    public val tileLayout: ThemeConfigurationSheetTileLayout? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.ThemeConfigurationSheet): ThemeConfigurationSheet = ThemeConfigurationSheet(
            tile = javaType.tile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfigurationSheetTile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tileLayout = javaType.tileLayout().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfigurationSheetTileLayout.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
