@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property gutter The gutter settings that apply between tiles. See gutter.
 * @property margin The margin settings that apply around the outside edge of sheets. See margin.
 */
public data class ThemeConfigurationSheetTileLayout(
    public val gutter: ThemeConfigurationSheetTileLayoutGutter? = null,
    public val margin: ThemeConfigurationSheetTileLayoutMargin? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.ThemeConfigurationSheetTileLayout): ThemeConfigurationSheetTileLayout = ThemeConfigurationSheetTileLayout(
            gutter = javaType.gutter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfigurationSheetTileLayoutGutter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            margin = javaType.margin().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfigurationSheetTileLayoutMargin.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
