@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accent Color (hexadecimal) that applies to selected states and buttons.
 * @property accentForeground Color (hexadecimal) that applies to any text or other elements that appear over the accent color.
 * @property danger Color (hexadecimal) that applies to error messages.
 * @property dangerForeground Color (hexadecimal) that applies to any text or other elements that appear over the error color.
 * @property dimension Color (hexadecimal) that applies to the names of fields that are identified as dimensions.
 * @property dimensionForeground Color (hexadecimal) that applies to any text or other elements that appear over the dimension color.
 * @property measure Color (hexadecimal) that applies to the names of fields that are identified as measures.
 * @property measureForeground Color (hexadecimal) that applies to any text or other elements that appear over the measure color.
 * @property primaryBackground Color (hexadecimal) that applies to visuals and other high emphasis UI.
 * @property primaryForeground Color (hexadecimal) of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.
 * @property secondaryBackground Color (hexadecimal) that applies to the sheet background and sheet controls.
 * @property secondaryForeground Color (hexadecimal) that applies to any sheet title, sheet control text, or UI that appears over the secondary background.
 * @property success Color (hexadecimal) that applies to success messages, for example the check mark for a successful download.
 * @property successForeground Color (hexadecimal) that applies to any text or other elements that appear over the success color.
 * @property warning Color (hexadecimal) that applies to warning and informational messages.
 * @property warningForeground Color (hexadecimal) that applies to any text or other elements that appear over the warning color.
 */
public data class ThemeConfigurationUiColorPalette(
    public val accent: String? = null,
    public val accentForeground: String? = null,
    public val danger: String? = null,
    public val dangerForeground: String? = null,
    public val dimension: String? = null,
    public val dimensionForeground: String? = null,
    public val measure: String? = null,
    public val measureForeground: String? = null,
    public val primaryBackground: String? = null,
    public val primaryForeground: String? = null,
    public val secondaryBackground: String? = null,
    public val secondaryForeground: String? = null,
    public val success: String? = null,
    public val successForeground: String? = null,
    public val warning: String? = null,
    public val warningForeground: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.quicksight.outputs.ThemeConfigurationUiColorPalette): ThemeConfigurationUiColorPalette = ThemeConfigurationUiColorPalette(
            accent = javaType.accent().map({ args0 -> args0 }).orElse(null),
            accentForeground = javaType.accentForeground().map({ args0 -> args0 }).orElse(null),
            danger = javaType.danger().map({ args0 -> args0 }).orElse(null),
            dangerForeground = javaType.dangerForeground().map({ args0 -> args0 }).orElse(null),
            dimension = javaType.dimension().map({ args0 -> args0 }).orElse(null),
            dimensionForeground = javaType.dimensionForeground().map({ args0 -> args0 }).orElse(null),
            measure = javaType.measure().map({ args0 -> args0 }).orElse(null),
            measureForeground = javaType.measureForeground().map({ args0 -> args0 }).orElse(null),
            primaryBackground = javaType.primaryBackground().map({ args0 -> args0 }).orElse(null),
            primaryForeground = javaType.primaryForeground().map({ args0 -> args0 }).orElse(null),
            secondaryBackground = javaType.secondaryBackground().map({ args0 -> args0 }).orElse(null),
            secondaryForeground = javaType.secondaryForeground().map({ args0 -> args0 }).orElse(null),
            success = javaType.success().map({ args0 -> args0 }).orElse(null),
            successForeground = javaType.successForeground().map({ args0 -> args0 }).orElse(null),
            warning = javaType.warning().map({ args0 -> args0 }).orElse(null),
            warningForeground = javaType.warningForeground().map({ args0 -> args0 }).orElse(null),
        )
    }
}
