@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin

import com.pulumi.aws.ram.RamFunctions.getResourceSharePlain
import com.pulumi.aws.ram.kotlin.inputs.GetResourceShareFilter
import com.pulumi.aws.ram.kotlin.inputs.GetResourceSharePlainArgs
import com.pulumi.aws.ram.kotlin.inputs.GetResourceSharePlainArgsBuilder
import com.pulumi.aws.ram.kotlin.outputs.GetResourceShareResult
import com.pulumi.aws.ram.kotlin.outputs.GetResourceShareResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

public object RamFunctions {
    /**
     * `aws.ram.ResourceShare` Retrieve information about a RAM Resource Share.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ram.getResourceShare({
     *     name: "example",
     *     resourceOwner: "SELF",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ram.get_resource_share(name="example",
     *     resource_owner="SELF")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ram.GetResourceShare.Invoke(new()
     *     {
     *         Name = "example",
     *         ResourceOwner = "SELF",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ram.LookupResourceShare(ctx, &ram.LookupResourceShareArgs{
     * 			Name:          pulumi.StringRef("example"),
     * 			ResourceOwner: "SELF",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ram.RamFunctions;
     * import com.pulumi.aws.ram.inputs.GetResourceShareArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RamFunctions.getResourceShare(GetResourceShareArgs.builder()
     *             .name("example")
     *             .resourceOwner("SELF")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ram:getResourceShare
     *       Arguments:
     *         name: example
     *         resourceOwner: SELF
     * ```
     * <!--End PulumiCodeChooser -->
     * ## Search by filters
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const tagFilter = aws.ram.getResourceShare({
     *     resourceOwner: "SELF",
     *     filters: [{
     *         name: "NameOfTag",
     *         values: ["exampleNameTagValue"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * tag_filter = aws.ram.get_resource_share(resource_owner="SELF",
     *     filters=[{
     *         "name": "NameOfTag",
     *         "values": ["exampleNameTagValue"],
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var tagFilter = Aws.Ram.GetResourceShare.Invoke(new()
     *     {
     *         ResourceOwner = "SELF",
     *         Filters = new[]
     *         {
     *             new Aws.Ram.Inputs.GetResourceShareFilterInputArgs
     *             {
     *                 Name = "NameOfTag",
     *                 Values = new[]
     *                 {
     *                     "exampleNameTagValue",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ram.LookupResourceShare(ctx, &ram.LookupResourceShareArgs{
     * 			ResourceOwner: "SELF",
     * 			Filters: []ram.GetResourceShareFilter{
     * 				{
     * 					Name: "NameOfTag",
     * 					Values: []string{
     * 						"exampleNameTagValue",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ram.RamFunctions;
     * import com.pulumi.aws.ram.inputs.GetResourceShareArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var tagFilter = RamFunctions.getResourceShare(GetResourceShareArgs.builder()
     *             .resourceOwner("SELF")
     *             .filters(GetResourceShareFilterArgs.builder()
     *                 .name("NameOfTag")
     *                 .values("exampleNameTagValue")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   tagFilter:
     *     fn::invoke:
     *       Function: aws:ram:getResourceShare
     *       Arguments:
     *         resourceOwner: SELF
     *         filters:
     *           - name: NameOfTag
     *             values:
     *               - exampleNameTagValue
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResourceShare.
     * @return A collection of values returned by getResourceShare.
     */
    public suspend fun getResourceShare(argument: GetResourceSharePlainArgs): GetResourceShareResult =
        toKotlin(getResourceSharePlain(argument.toJava()).await())

    /**
     * @see [getResourceShare].
     * @param filters Filter used to scope the list e.g., by tags. See [related docs] (https://docs.aws.amazon.com/ram/latest/APIReference/API_TagFilter.html).
     * @param name Name of the resource share to retrieve.
     * @param resourceOwner Owner of the resource share. Valid values are `SELF` or `OTHER-ACCOUNTS`.
     * @param resourceShareStatus Specifies that you want to retrieve details of only those resource shares that have this status. Valid values are `PENDING`, `ACTIVE`, `FAILED`, `DELETING`, and `DELETED`.
     * @param tags Tags attached to the resource share.
     * @return A collection of values returned by getResourceShare.
     */
    public suspend fun getResourceShare(
        filters: List<GetResourceShareFilter>? = null,
        name: String? = null,
        resourceOwner: String,
        resourceShareStatus: String? = null,
        tags: Map<String, String>? = null,
    ): GetResourceShareResult {
        val argument = GetResourceSharePlainArgs(
            filters = filters,
            name = name,
            resourceOwner = resourceOwner,
            resourceShareStatus = resourceShareStatus,
            tags = tags,
        )
        return toKotlin(getResourceSharePlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceShare].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ram&#46;kotlin&#46;inputs&#46;GetResourceSharePlainArgs].
     * @return A collection of values returned by getResourceShare.
     */
    public suspend fun getResourceShare(argument: suspend GetResourceSharePlainArgsBuilder.() -> Unit): GetResourceShareResult {
        val builder = GetResourceSharePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getResourceSharePlain(builtArgument.toJava()).await())
    }
}
