@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ResourceShare].
 */
@PulumiTagMarker
public class ResourceShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceShareArgs = ResourceShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceShareArgsBuilder.() -> Unit) {
        val builder = ResourceShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceShare {
        val builtJavaResource = com.pulumi.aws.ram.ResourceShare(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceShare(builtJavaResource)
    }
}

/**
 * Manages a Resource Access Manager (RAM) Resource Share. To associate principals with the share, see the `aws.ram.PrincipalAssociation` resource. To associate resources with the share, see the `aws.ram.ResourceAssociation` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ram.ResourceShare("example", {
 *     name: "example",
 *     allowExternalPrincipals: true,
 *     tags: {
 *         Environment: "Production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ram.ResourceShare("example",
 *     name="example",
 *     allow_external_principals=True,
 *     tags={
 *         "Environment": "Production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ram.ResourceShare("example", new()
 *     {
 *         Name = "example",
 *         AllowExternalPrincipals = true,
 *         Tags =
 *         {
 *             { "Environment", "Production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewResourceShare(ctx, "example", &ram.ResourceShareArgs{
 * 			Name:                    pulumi.String("example"),
 * 			AllowExternalPrincipals: pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.ResourceShare;
 * import com.pulumi.aws.ram.ResourceShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceShare("example", ResourceShareArgs.builder()
 *             .name("example")
 *             .allowExternalPrincipals(true)
 *             .tags(Map.of("Environment", "Production"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ram:ResourceShare
 *     properties:
 *       name: example
 *       allowExternalPrincipals: true
 *       tags:
 *         Environment: Production
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import resource shares using the `arn` of the resource share. For example:
 * ```sh
 * $ pulumi import aws:ram/resourceShare:ResourceShare example arn:aws:ram:eu-west-1:123456789012:resource-share/73da1ab9-b94a-4ba3-8eb4-45917f7f4b12
 * ```
 */
public class ResourceShare internal constructor(
    override val javaResource: com.pulumi.aws.ram.ResourceShare,
) : KotlinCustomResource(javaResource, ResourceShareMapper) {
    /**
     * Indicates whether principals outside your organization can be associated with a resource share.
     */
    public val allowExternalPrincipals: Output<Boolean>?
        get() = javaResource.allowExternalPrincipals().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the resource share.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the resource share.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the Amazon Resource Names (ARNs) of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
     */
    public val permissionArns: Output<List<String>>
        get() = javaResource.permissionArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource share. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ResourceShareMapper : ResourceMapper<ResourceShare> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ram.ResourceShare::class == javaResource::class

    override fun map(javaResource: Resource): ResourceShare = ResourceShare(
        javaResource as
            com.pulumi.aws.ram.ResourceShare,
    )
}

/**
 * @see [ResourceShare].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceShare].
 */
public suspend fun resourceShare(
    name: String,
    block: suspend ResourceShareResourceBuilder.() -> Unit,
): ResourceShare {
    val builder = ResourceShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceShare].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceShare(name: String): ResourceShare {
    val builder = ResourceShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
